// CtrlCard.cpp: implementation of the CCtrlCard class. 
// 
////////////////////////////////////////////////////////////////////// 

# include "stdafx.h" 
# include "DEMO.h" 
# include "CtrlCard.h" 
# include "adt8960m.h" 


# ifdef _DEBUG 
# undef THIS_FILE 
static char THIS_FILE []=__ FILE__; 
# define new DEBUG_NEW 
# endif 

////////////////////////////////////////////////////////////////////// 
// Construction / Destruction 
////////////////////////////////////////////////////////////////////// 

int cardno = 0; // card number 

CCtrlCard:: CCtrlCard () 
{ 

} 
/******************* Initialization function ************************ 

    This function initializes the control card contains commonly used library functions, which is called 
     
    The basis of other functions, it must first call in the example program 
     
    Return value <= 0 initialization failed, the return value> 0 indicates a successful initialization 

************************************************** ***/ 
int CCtrlCard:: Init_Board () 
{ 
Result = adt8960_initial (); // initialization function card 

if (Result <= 0) return Result; 
     
    for (int i = 1; i <= MAXAXIS; i ++) 
{ 
       for (int j = 0; j <Result; j ++) 
{ 
adt8960_set_limit_mode (j, i, 0, 0, 0); // set the limit mode, set the positive and negative limit, active-low 
    
adt8960_set_command_pos (j, i, 0); // clear logic counter 
    
adt8960_set_actual_pos (j, i, 0); // real position counter clear 
    
adt8960_set_startv (j, i, 1000); // set the starting speed 
    
adt8960_set_speed (j, i, 1000); // set the drive speed 

adt8960_set_acc (j, i, 625); // Set Acceleration 
} 
    } 
     
    return Result; 

} 


/********************** Set speed module *********************** 

    Based on value of the parameter to determine a uniform or accelerated 

Setting the initial speed of the shaft, drive speed and acceleration 

    Parameters: axis - Axis No. 

startv - initial velocity 

speed - drive speed 

          add - Acceleration 
     
    Return value = 0 correct, an error return value = 1 

************************************************** *******/ 
int CCtrlCard:: Setup_Speed (int axis, long startv, long speed, long add, int mode) 
{ 
if (startv - speed>= 0) // uniform motion 
{ 
Result = adt8960_set_startv (cardno, axis, startv); 

adt8960_set_speed (cardno, axis, startv); 
} 
else // acceleration 
{ 
if (mode == 0) // trapezoidal acceleration and deceleration when selecting appropriate treatment when 
{ 
adt8960_set_ad_mode (cardno, axis, 0); // set to the trapezoidal acceleration and deceleration mode 

Result = adt8960_set_startv (cardno, axis, startv); 

adt8960_set_speed (cardno, axis, speed); 

adt8960_set_acc (cardno, axis, add/125); 
} 
else if (mode == 1) // S curve acceleration and deceleration when selecting appropriate treatment when 
{ 
float time; // Definition of time 

float addvar; // acceleration rate of change 

long k; // results to be calculated 

time = (float) (speed-startv) / (add / 2); // the acceleration time 

addvar = add / (time / 2); // acceleration rate of change 

k = (long) (1000000/addvar); 

adt8960_set_ad_mode (cardno, axis, 1 );//// set to S curve acceleration and deceleration mode 

adt8960_set_startv (cardno, axis, startv); 

adt8960_set_speed (cardno, axis, speed); 

adt8960_set_acc (cardno, axis, add/125); 

adt8960_set_acac (cardno, axis, k); 
} 
} 

return Result; 

} 
/********************* Axis drive functions ********************** 

    This function is used to drive a single axis motion 

    Parameters: axis-axis number, pulse-output pulses 
     
    Return value = 0 correct, an error return value = 1 

************************************************** *****/ 
int CCtrlCard:: Axis_Pmove (int axis, long pulse) 
{ 
Result = adt8960_pmove (cardno, axis, pulse); 

return Result; 

} 


/************************ Uniaxial continuous drive function ******************** *** 

    This function is used to drive a single axis motion 

    Parameters: axis-axis number, value-pulse direction 
     
    Return value = 0 correct, an error return value = 1 

************************************************** *********/ 
int CCtrlCard:: Axis_ConMove (int axis, long dir) 
{ 
Result = adt8960_continue_move (cardno, axis, dir); 

return Result; 

} 
/******************* Any two axis interpolation function ******************** 

    This function is used to drive any two axes interpolated motion 

    Parameters: axis1, axis2-axis numbers, pulse1, pulse2-pulses 
     
    Return value = 0 correct, an error return value = 1 

************************************************** *****/ 
int CCtrlCard:: Interp_Move2 (int axis1, int axis2, long pulse1, long pulse2) 
{ 
Result = adt8960_inp_move2 (cardno, axis1, axis2, pulse1, pulse2); 

return Result; 

} 
/******************* Arbitrary axis interpolation function ******************** 

    This function is used to drive any axes motion interpolation 

    Parameters: axis1, axis2, axis3-axis numbers, pulse1, pulse2, pulse3-pulses 
     
    Return value = 0 correct, an error return value = 1 

************************************************** *****/ 
int CCtrlCard:: Interp_Move3 (int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3) 
{ 
Result = adt8960_inp_move3 (cardno, axis1, axis2, axis3, pulse1, pulse2, pulse3); 

return Result; 

} 

/******************* Arbitrary axis interpolation function ************************ **** 

    This function is used to interpolate movement axis drive any 
     
Parameters: axis1, axis2, axis3, axis4-axis No. 

pulse1, pulse2, pulse3, pulse4-output pulses 

    Return value = 0 correct, an error return value = 1 

************************************************** *********/ 
int CCtrlCard:: Interp_Move4 (int axis1, int axis2, int axis3, int axis4, long pulse1, long pulse2, long pulse3, long pulse4) 
{ 
Result = adt8960_inp_move4 (cardno, axis1, axis2, axis3, axis4, pulse1, pulse2, pulse3, pulse4); 

return Result; 
} 


 /********************* *Any five-axis interpolation functions ********************** 

    This function is used to interpolate axis movements drive any 
     
Parameters: axis1, axis2, axis3, axis4, axis5-axis No. 

pulse1, pulse2, pulse3, pulse4, pulse5-output pulses 

    Return value = 0 correct, an error return value = 1 

************************************************** *********/ 
int CCtrlCard:: Interp_Move5 (int axis1, int axis2, int axis3, int axis4, int axis5, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5) 
{ 
Result = adt8960_inp_move5 (cardno, axis1, axis2, axis3, axis4, axis5, pulse1, pulse2, pulse3, pulse4, pulse5); 

return Result; 
} 

/************************* Six-axis interpolation function ******************* *** 

    This function is used to drive the six-axis motion interpolation 
     
Parameters: pulse1, pulse2, pulse3, pulse4, pulse5, pulse6-output pulses 

    Return value = 0 correct, an error return value = 1 

************************************************** *********/ 
int CCtrlCard:: Interp_Move6 (long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long pulse6) 
{ 
Result = adt8960_inp_move6 (cardno, pulse1, pulse2, pulse3, pulse4, pulse5, pulse6); 

return Result; 
} 

/************************ Stop shaft drive ********************** * 

    This function is used to stop immediately or decelerate the drive shaft 

Parameters: axis-axis number, mode-slow mode (0 - stop, 1 - deceleration stop) 
     
    Return value = 0 correct, an error return value = 1 

************************************************** **********/ 
int CCtrlCard:: StopRun (int axis, int mode) 
{ 
if (mode == 0) // stop 
     
        Result = adt8960_sudden_stop (cardno, axis); 
         
    else // deceleration stop 
     
        Result = adt8960_dec_stop (cardno, axis); 
         
    return Result; 

} 
/********************* Status for the drive shaft ********************** 

    This function is used to obtain single-axis drive state or interpolation driving status 

    Parameters: axis-axis number, pulse-state pointer (0 - drive end, non-0 - is driving) 

mode (0 - for single-axis drive status, 1 - to obtain interpolation driving status) 
     
    Return value = 0 correct, an error return value = 1 

************************************************** **********/ 
int CCtrlCard:: Get_Status (int axis, int & pulse, int mode) 
{ 
if (mode == 0) // for single-axis drive status 

Result = adt8960_get_status (cardno, axis, & pulse); 

else // Get interpolation driving status 

Result = adt8960_get_inp_status (cardno, & pulse); 

return Result; 

} 

/***************** Access to sports information ***************************** * 

    This function is used to feedback the logic of the current axis position, actual position and speed 

    Parameters: axis-axis number, LogPos-logical position, ActPos-physical location, Speed-speed 
     
    Return value = 0 correct, an error return value = 1 

************************************************** **********/ 
int CCtrlCard:: Get_CurrentInf (int axis, long & LogPos, long & ActPos, long & Speed) 
{ 
Result = adt8960_get_command_pos (cardno, axis, & LogPos); 

adt8960_get_actual_pos (cardno, axis, & ActPos); 

adt8960_get_speed (cardno, axis, & Speed); 

return Result; 

} 

/*********************** Read input ********************** ********* 

     This function is used to read a single entry point 

     Parameters: number-input (0 ~ 31) 

     Returns: 0 - low, 1 - high, -1-- error 

************************************************** **************/ 
int CCtrlCard:: Read_Input (int number) 
{ 
Result = adt8960_read_bit (cardno, number); 
     
return Result; 
} 

/********************* Output single point function ************************ ****** 

    This function is used to output a single point of signal 

    Parameters: number-Output (0 ~ 15), pulse 0 - low, 1 - high 

    Return value = 0 correct, an error return value = 1 
************************************************** **************/ 

int CCtrlCard:: Write_Output (int number, int pulse) 
{ 
Result = adt8960_write_bit (cardno, number, pulse); 

return Result; 

} 
/******************* Set the location counter *************************** **** 

     This function is used to set the logical position and actual position 

     Parameters: axis-axis number, pos-set position value 
mode 0 - set the logical location, non-0 - set the actual position 

     Return value = 0 correct, an error return value = 1 
************************************************** **************/ 

int CCtrlCard:: Setup_Pos (int axis, long pos, int mode) 
{ 
if (mode == 0) 
{ 
Result = adt8960_set_command_pos (cardno, axis, pos); 
} 
else 
{ 
Result = adt8960_set_actual_pos (cardno, axis, pos); 
} 

return Result; 

} 
 /********************Get version information ************************ 
       
This function is used to obtain the hardware version 

Parameters: LibVer-hardware version number 

************************************************** *******/ 
void CCtrlCard:: Get_Version (float & hardVer) 
{ 
// Float Ver; 
hardVer = adt8960_get_hardware_ver (cardno); 
// LibVer = float (Ver/256); 
} 
/******************** Set the pulse output mode ********************** 
       
This function is used to set the pulse of the work 

Parameters: axis-axis number, pulse-pulse mode 0 - pulse + pulse 1 - Pulse + direction method 

    Return value = 0 correct, an error return value = 1 

    The default pulse mode for the pulse + direction 

    This program uses the default positive logic pulse and direction output signals are logic 

************************************************** *******/ 
int CCtrlCard:: Setup_PulseMode (int axis, int pulse) 
{ 
Result = adt8960_set_pulse_mode (cardno, axis, pulse, 0, 0); 

return Result; 

} 
/******************** Set limit signaling ********************** 

   This function is used to set the positive / negative direction limit input signal mode nLMT 

   Parameters: axis-axis No. 
          pulse1 0 - is the effective limit 1 - is the limit is not valid 
pulse2 0 - negative limit effective 1 - negative limit is not valid 
logic 0 - active LOW 1 - active HIGH 
   The default mode is: is the effective limit the negative limit, active-low 

   Return value = 0 correct, an error return value = 1 
  ************************************************** *******/ 
int CCtrlCard:: Setup_LimitMode (int axis, int pulse1, int pulse2, int logic) 
{ 
Result = adt8960_set_limit_mode (cardno, axis, pulse1, pulse2, logic); 

return Result; 

} 
/******************** Set stop0 signaling ********************** 

   This function is used to set the signal mode stop0 

   Parameters: axis-axis No. 
          pulse 0 - invalid 1 - Effective 
logic 0 - active LOW 1 - active HIGH 
   The default mode: Invalid 

   Return value = 0 correct, an error return value = 1 
  ************************************************** *******/ 
int CCtrlCard:: Setup_Stop0Mode (int axis, int pulse, int logic) 
{ 
Result = adt8960_set_stop0_mode (cardno, axis, pulse, logic); 

return Result; 

} 
/******************** Set stop1 signaling ********************** 

   This function is used to set the signal mode stop1 

   Parameters: axis-axis No. 
          pulse 0 - invalid 1 - Effective 
logic 0 - active LOW 1 - active HIGH 
   The default mode: Invalid 

   Return value = 0 correct, an error return value = 1 
  ************************************************** *******/ 
int CCtrlCard:: Setup_Stop1Mode (int axis, int pulse, int logic) 
{ 
Result = adt8960_set_stop1_mode (cardno, axis, pulse, logic); 

return Result; 

} 

/******************** Set the hardware stop mode ********************** 

   This function is used to set the hardware stop signal pattern 

   Parameters: pulse 0 - invalid 1 - Effective 
logic 0 - active LOW 1 - active HIGH 
   The default mode: Invalid 

   Return value = 0 correct, an error return value = 1 

   Stop signal is fixed to use the hardware P3 34-pin terminal block (IN31) 
  ************************************************** *******/ 
int CCtrlCard:: Setup_HardStop (int pulse, int logic) 
{ 
Result = adt8960_set_suddenstop_mode (cardno, pulse, logic); 

return Result; 

} 
/******************** Set delay ********************** 

   This function is used to set the delay 

   Parameters: time - delay time (in us) 

   Return value = 0 correct, an error return value = 1 

  ************************************************** *******/ 
int CCtrlCard:: Setup_Delay (long time) 
{ 
Result = adt8960_set_delay_time (cardno, time * 8); 

return Result; 

} 
/******************** For delay status ********************** 

   The delay function for the state 

   Return Value 0 - delay the end of 1 - Delay in progress 

  ************************************************** *******/ 
int CCtrlCard:: Get_DelayStatus () 
{ 
Result = adt8960_get_delay_status (cardno); 

return Result; 
} 

/******************** Set common input and output ********************** 

   This function is used to set the general-purpose input-output 

   Parameters: 
v1-0: 8 points in front of the input is defined as 1: 8 points in front of the output is defined as 

v2-0: 8 points behind the input is defined as 1: 8 points behind is defined as the output 

   Return value = 0 correct, an error return value = 1 

   Note: When the IO point when used as outputs and can also read the input status 
  ************************************************** *******/ 
int CCtrlCard:: Set_IoMode (int v1, int v2) 
{ 
Result = adt8960_set_io_mode (cardno, v1, v2); 

return Result; 
} 


/***************************** Axis relative motion **************** ***** 
* Function: with reference to the current position, move to accelerate the quantitative 
* Parameters: 
      cardno-card 
axis --- Axis No. 
pulse - pulse 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoidal, 1: S curve) 
Return Value 0: Correct 1: Error 
************************************************** *****************/ 
int CCtrlCard:: Sym_RelativeMove (int axis, long pulse, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = adt8960_symmetry_relative_move (cardno, axis, pulse, lspd, hspd, tacc, vacc, mode); 

    return Result; 
} 

/*************************** Axis absolute Mobile ****************** ****** 
* Function: zero reference position to accelerate the move to quantify 
* Parameters: 
      cardno-card 
axis --- Axis No. 
pulse - pulse 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoidal, 1: S curve) 
Return Value 0: Correct 1: Error 
************************************************** ******************/ 
int CCtrlCard:: Sym_AbsoluteMove (int axis, long pulse, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = adt8960_symmetry_absolute_move (cardno, axis, pulse, lspd, hspd, tacc, vacc, mode); 

    return Result; 
} 
/********************** Two-axis linear interpolation is relatively mobile ******************** 
* Function: with reference to the current location to speed up the linear interpolation 
* Parameters: 
      cardno-card 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoidal, 1: S curve) 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 
int CCtrlCard:: Sym_RelativeLine2 (int axis1, int axis2, long pulse1, long pulse2, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = adt8960_symmetry_relative_line2 (cardno, axis1, axis2, pulse1, pulse2, lspd, hspd, tacc, vacc, mode); 

    return Result; 
} 

/******************** Absolute two-axis linear interpolation move ********************** 
* Function: zero reference position to expedite the linear interpolation 
* Parameters: 
      cardno-card 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoidal, 1: S curve) 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 
int CCtrlCard:: Sym_AbsoluteLine2 (int axis1, int axis2, long pulse1, long pulse2, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = adt8960_symmetry_absolute_line2 (cardno, axis1, axis2, pulse1, pulse2, lspd, hspd, tacc, vacc, mode); 

    return Result; 
} 

/********************** Axis linear interpolation relative motion ******************** 
* Function: with reference to the current location to speed up the linear interpolation 
* Parameters: 
      cardno-card 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoidal, 1: S curve) 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 
int CCtrlCard:: Sym_RelativeLine3 (int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = adt8960_symmetry_relative_line3 (cardno, axis1, axis2, axis3, pulse1, pulse2, pulse3, lspd, hspd, tacc, vacc, mode); 

    return Result; 
} 


/********************* Absolute motion ********************* axis linear interpolation 
Features: zero reference position to expedite the linear interpolation 
Parameters: 
      cardno-card 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoidal, 1: S curve) 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 
int CCtrlCard:: Sym_AbsoluteLine3 (int axis1, int axis2, int axis3, long pulse1, long pulse2, long pulse3, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = adt8960_symmetry_absolute_line3 (cardno, axis1, axis2, axis3, pulse1, pulse2, pulse3, lspd, hspd, tacc, vacc, mode); 

    return Result; 
} 

/***************** Axis linear interpolation relative motion **************** 
* Function: with reference to the current location to speed up the linear interpolation 
* Parameters: 
      cardno-card 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
axis4 --- Shaft No. 4 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoidal, 1: S curve) 
************************************************** ****/ 
int CCtrlCard:: Sym_RelativeLine4 (int axis1, int axis2, int axis3, int axis4, long pulse1, long pulse2, long pulse3, long pulse4, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = adt8960_symmetry_relative_line4 (cardno, axis1, axis2, axis3, axis4, pulse1, pulse2, pulse3, pulse4, lspd, hspd, tacc, vacc, mode); 
     
return Result; 
} 

/***************** Absolute motion **************** axis linear interpolation 
* Function: zero reference position to expedite the linear interpolation 
* Parameters: 
      cardno-card 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
axis4 --- Shaft No. 4 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoidal, 1: S curve) 
************************************************** ****/ 
int CCtrlCard:: Sym_AbsoluteLine4 (int axis1, int axis2, int axis3, int axis4, long pulse1, long pulse2, long pulse3, long pulse4, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = adt8960_symmetry_absolute_line4 (cardno, axis1, axis2, axis3, axis4, pulse1, pulse2, pulse3, pulse4, lspd, hspd, tacc, vacc, mode); 

return Result; 
} 

/***************** Axis linear interpolation relative motion **************** 
* Function: with reference to the current location to speed up the linear interpolation 
* Parameters: 
      cardno-card 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
axis4 --- Shaft No. 4 
axis5 --- No. 5 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
pulse5 - Pulse 5 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoidal, 1: S curve) 
************************************************** ****/ 
int CCtrlCard:: Sym_RelativeLine5 (int axis1, int axis2, int axis3, int axis4, int axis5, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long lspd, long hspd, double tacc, long vacc, int mode ) 
{ 
Result = adt8960_symmetry_relative_line5 (cardno, axis1, axis2, axis3, axis4, axis5, pulse1, pulse2, pulse3, pulse4, pulse5, lspd, hspd, tacc, vacc, mode); 
     
return Result; 
} 

/***************** Axis linear interpolation absolute motion **************** 
* Function: with reference to the zero position, in order to speed up the linear interpolation 
* Parameters: 
      cardno-card 
axis1 --- Shaft No. 1 
axis2 --- No. 2 shaft 
axis3 --- No. 3 shaft 
axis4 --- Shaft No. 4 
axis5 --- No. 5 shaft 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
      pulse5 - Pulse 5 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoidal, 1: S curve) 
************************************************** ****/ 
int CCtrlCard:: Sym_AbsoluteLine5 (int axis1, int axis2, int axis3, int axis4, int axis5, long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long lspd, long hspd, double tacc, long vacc, int mode ) 
{ 
Result = adt8960_symmetry_absolute_line5 (cardno, axis1, axis2, axis3, axis4, axis5, pulse1, pulse2, pulse3, pulse4, pulse5, lspd, hspd, tacc, vacc, mode); 

return Result; 
} 

/***************** Six-axis linear interpolation relative motion **************** 
* Function: with reference to the current location to speed up the linear interpolation 
* Parameters: 
      cardno-card 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
pulse5 - Pulse 5 
pulse6 - Pulse 6 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoidal, 1: S curve) 
************************************************** ****/ 
int CCtrlCard:: Sym_RelativeLine6 (long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long pulse6, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = adt8960_symmetry_relative_line6 (cardno, pulse1, pulse2, pulse3, pulse4, pulse5, pulse6, lspd, hspd, tacc, vacc, mode); 
     
return Result; 
} 

/***************** Six-axis linear interpolation absolute motion **************** 
* Function: with reference to the zero position, in order to speed up the linear interpolation 
* Parameters: 
      cardno-card 
pulse1 - Pulse 1 
pulse2 - Pulse 2 
pulse3 - Pulse 3 
pulse4 - Pulse 4 
pulse5 - Pulse 5 
pulse6 - Pulse 6 
lspd --- low 
hspd --- High-speed 
      tacc --- acceleration time (unit: seconds) 
vacc --- acceleration rate of change 
mode --- acceleration mode (0: trapezoidal, 1: S curve) 
************************************************** ****/ 
int CCtrlCard:: Sym_AbsoluteLine6 (long pulse1, long pulse2, long pulse3, long pulse4, long pulse5, long pulse6, long lspd, long hspd, double tacc, long vacc, int mode) 
{ 
Result = adt8960_symmetry_absolute_line6 (cardno, pulse1, pulse2, pulse3, pulse4, pulse5, pulse6, lspd, hspd, tacc, vacc, mode); 

return Result; 
} 

/******************** For Output ************************** ******* 
Function: Get Output 
Parameters: 
cardno card number 
Output number 
Return value Returns: the current state of specified port, -1 means the parameter error 
************************************************** ***/ 
int CCtrlCard:: Get_OutNum (int number) 
{ 
Result = adt8960_get_out (cardno, number); 

return Result; 
} 

/************************ Quantitatively driven manually ********************** ********** 
Function: Enables Quantitative drive functions Manual 
Parameters: 
No. axis axis 
pulse pulse 
Return Value 0: Correct 1: Error 
************************************************** *********/ 
int CCtrlCard:: Manu_Pmove (int axis, long pulse) 
{ 
Result = adt8960_manual_pmove (cardno, axis, pulse); 

return Result; 
} 

/************************ Manual continuous drive ********************** ********** 
Function: Enables manual continuous drive function 
Parameters: 
No. axis axis 
Return Value 0: Correct 1: Error 
************************************************** *********/ 
int CCtrlCard:: Manu_Continue (int axis) 
{ 
Result = adt8960_manual_continue (cardno, axis); 

return Result; 
} 

/************************ Closed manually driven ********************** ********** 
Function: Close external signal drive 
Parameters: 
No. axis axis 
Return Value 0: Correct 1: Error 
************************************************** *********/ 
int CCtrlCard:: Manu_Disable (int axis) 
{ 
Result = adt8960_manual_disable (cardno, axis); 

return Result; 
} 

/**************************** Position latch set functions **************** ****** 
Function: signaling functions set in place, locked position of all axes and the actual location of the logic 
Parameters: 
axis-reference axis 
mode - Latch mode | 0: Invalid 
| 1: Effective 
regi-Counter Mode | 0: logical location 
| 1: actual position 
logical-level signal | 0: rising edge 
| 1: falling 
Return Value 0: Correct 1: Error 
Note: Use the specified axis axis of the IN signal as the trigger signal 
************************************************** *****************/ 
int CCtrlCard:: Setup_LockPosition (int axis, int mode, int regi, int logical) 
{ 
Result = adt8960_set_lock_position (cardno, axis, mode, regi, logical); 

return Result; 
} 

/************************* Get latched state ******************** *** 
Function: Get the state of synchronous operation 
Parameters: 
No. axis axis 
v 0 | not perform latch operation 
1 | latch operation performed 
Return Value 0: Correct 1: Error 
Description: Use this function to capture the position of whether to implement latch 
************************************************** ****************/ 
int CCtrlCard:: Get_LockStatus (int axis, int & v) 
{ 
      Result = adt8960_get_lock_status (cardno, axis, & v); 

return Result; 
} 

/************************** Get locked position ******************* ******* 
Features: access to the locked position 
Parameters: 
No. axis axis 
latched position pos 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 
int CCtrlCard:: Get_LockPosition (int axis, long & pos) 
{ 
Result = adt8960_get_lock_position (cardno, axis, & pos); 

    return Result; 
} 

/************************** Clear latched status ******************* ******* 
Function: Clear latched status 
Parameters: 
No. axis axis (1-4) 
Return Value 0: Correct 1: Error 
************************************************** ****************/ 
int CCtrlCard:: Clr_LockPosition (int axis) 
{ 
Result = adt8960_clr_lock_status (cardno, axis); 

    return Result; 
}